# Minimal wrapt shim for deprecated library usage
import functools

class AdapterFactory(object):
    def __init__(self, *args, **kwargs):
        pass

    def __call__(self, wrapped):
        return wrapped

def decorator(factory_func):
    def apply(wrapped):
        @functools.wraps(wrapped)
        def wrapper(*args, **kwargs):
            instance = args[0] if args else None
            return factory_func(wrapped, instance, args, kwargs)
        return wrapper
    return apply

