bl_info = {
    "name": "Hitem3D",
    "author": "Hitem3D",
    "version": (1, 0, 2),
    "blender": (2, 80, 0),
    "location": "View3D > Sidebar > Hitem3D",
    "description": "Open Hitem3D Model Generator website",
    "category": "3D View",
}

import bpy
from . import properties, operators, panels


def register():
    properties.register()
    operators.register()
    panels.register()
    from .logger import get_logger
    get_logger()



def unregister():
    panels.unregister()
    operators.unregister()
    properties.unregister()
    from .logger import close_logger
    close_logger()

